import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * GUI zum Sortieren und Anzeigen von Integers
 * Zufallszahlen,
 * Comboboxen, ScrollPanes, JTextAreas
 * 
 * @author docschroeder
 * @version 06.12.2015 Lehrer-/Schlervariante
 */

public class GUI extends JFrame implements ActionListener, ItemListener{
    private JLabel lMax,lMin,lSchnitt;
    private JButton bNeu;
    private JTextArea tListe;
    private JComboBox cbMethode;
    private JScrollPane sp;
    private String [] mName = {"","Selection Sort", "Bubble Sort", "Quick Sort"};

    private Zahlenliste zahlenliste;
    private String liste="";

    public GUI()    {
        super("Sortieren von Zahlen");

        zahlenliste = new Zahlenliste();
        zahlenliste.zahlenErzeugen();

        setSize(300,800);
        setLocation(200,30);
        setResizable(false);
        setDefaultCloseOperation(3);
        setLayout(null);

        getContentPane().setBackground(Color.YELLOW);

        tListe = new JTextArea("",zahlenliste.getLength(),5);
        tListe.setBackground(Color.WHITE);
        tListe.setFont(new Font("Arial",0,22));
        tListe.setText(zahlenliste.zahlenAusgeben());
        tListe.setEditable(false);
        sp = new JScrollPane(tListe);
        sp.setBounds(30,20,80,600);
        add(sp);

        cbMethode = new JComboBox(mName);
        cbMethode.setBounds(150,10,120,30);
        cbMethode.addItemListener(this);
        add(cbMethode);

        bNeu = new JButton("Neue Zahlen");
        bNeu.setFont(new Font("Arial",1,16));
        bNeu.setBounds(20,640,150,30);
        bNeu.addActionListener(this);
        add(bNeu);

        setVisible(true);

    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o==bNeu) {
            zahlenliste.zahlenErzeugen();
        } 
        cbMethode.addItemListener(this); //schaltet ItemListener fr Combobox mit NEUEN Zahlen wieder ein!
        tListe.setText(zahlenliste.zahlenAusgeben());
    }

    public void itemStateChanged(ItemEvent ie) {
        cbMethode.removeItemListener(this); //ItemEvents werden immer doppelt geworfen :-(

        if (cbMethode.getSelectedItem().toString().equals(mName[1])) { //Selection Sort
            zahlenliste.selectionSort();
        }
        if (cbMethode.getSelectedItem().toString().equals(mName[2])) { //Bubble Sort
            zahlenliste.bubbleSort();
        }
        if (cbMethode.getSelectedItem().toString().equals(mName[3])) { //Quick Sort
            zahlenliste.quickSort();
        }

        tListe.setText(zahlenliste.zahlenAusgeben());
    }

    public static void main(String[] args) {
        new GUI();
    }
}
