import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Die Klasse KeyPlusTimer zeigt, wie ein graphisches
 * Objekt durch die Pfeiltasten bewegt und zusätzlich
 * durch beliebige Tasten in seinen Eigenschaften
 * verändert werden kann.
 * Die Instanzen dieser Klasse werden von Ausgabe periodisch
 * verändert.
 * @author docschroeder
 * @version 08.12.2011
 */



public class KeyPlusTimer extends JFrame implements KeyListener
{
    private JFrame jf;
    private int x0,y0;

    public KeyPlusTimer()
    {
        x0=500;
        y0=50;
        jf = new JFrame("Jframe");
        jf.setBounds(x0,y0,100,100);
        jf.setVisible(true);
        jf.setLayout(null);
        jf.setDefaultCloseOperation(3);
        jf.addKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        x0 = jf.getX();
        y0 = jf.getY();

        switch (key) {
            case 37:

            if (x0>100) {
                x0 -= 20;
            }
            break;

            case 38:
            if (y0>10) {
                y0 -= 20;
            }
            break;

            case 39:
            if (x0<1000-10) {
                x0 += 20;
            }
            break;

            case 40:
            if (y0<700-10) {
                y0 += 20;
            }
            break;

            default:
            int grauton = (int) (Math.random()*256);
            jf.getContentPane().setBackground(new Color(grauton,grauton,grauton));
        }

        jf.setBounds(x0,y0,100,100);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
/** 
 * getJFrame() und setJFrame () sind Methoden, damit der Timer über die Methode run()
 * in der Klasse Ausgabe den Frame holen, anpassen
 * und zurückschreiben kann.
 */
    public JFrame getJFrame() {
        return jf;
    }

    public void setJFrame(JFrame pjf) {
        jf = pjf;
    }
}
