import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class GUI extends JFrame implements ActionListener{
    private JLabel lMax,lMin,lSchnitt;
    private JButton bSelSort,bBubSort,bQuickSort, bNeu;
    private TextArea tListe;
    private Zahlenliste zahlenliste;
    private String liste="";

    public GUI()    {
        super("Sortieren von Zahlen");
        setSize(300,800);
        setLocation(200,30);
        setResizable(false);
        setDefaultCloseOperation(3);
        setLayout(null);
        
        
        zahlenliste = new Zahlenliste();
        zahlenliste.zahlenErzeugen();

        
        tListe = new TextArea("",zahlenliste.getLength(),3,1);
        tListe.setBackground(Color.WHITE);
        tListe.setBounds(30,20,60,600);
        tListe.setText(zahlenliste.zahlenAusgeben());
        tListe.setEditable(false);
        add(tListe);

        bSelSort = new JButton("Selection Sort");
        bSelSort.setFont(new Font("Arial",0,10));
        bSelSort.setBounds(160,20,100,20);
        bSelSort.addActionListener(this);
        add(bSelSort);

        bBubSort = new JButton("Bubble Sort");
        bBubSort.setFont(new Font("Arial",0,10));
        bBubSort.setBounds(160,60,100,20);
        bBubSort.addActionListener(this);
        add(bBubSort);

        bQuickSort = new JButton("Quick Sort");
        bQuickSort.setFont(new Font("Arial",0,10));
        bQuickSort.setBounds(160,100,100,20);
        bQuickSort.addActionListener(this);
        add(bQuickSort);

        bNeu = new JButton("Neue Zahlen");
        bNeu.setFont(new Font("Arial",1,12));
        bNeu.setBounds(160,140,100,20);
        bNeu.addActionListener(this);
        add(bNeu);

        setVisible(true);

    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o==bNeu) {
            zahlenliste.zahlenErzeugen();
        } else if (o==bSelSort) {
            zahlenliste.selectionSort();
        } else if (o==bBubSort) {
            zahlenliste.bubbleSort();
        } else if (o==bQuickSort) {
            zahlenliste.quickSort();
        }
        tListe.setText(zahlenliste.zahlenAusgeben());
    }
    
    public static void main(String[] args) {
        new GUI();
    }
}
