import java.util.*;
import java.io.*;

/**
 * Vokabel verwaltet Deutsch-Englische
 * Vokabeln mit Zahl der korrekten und Zahl der falschen
 * Antworten sowie dem Datum des letzten Zugriffs
 * 
 * @author docschroeder
 * @version 10.09.2012
 */
public class Vokabel implements Serializable
{
    private String englisch, deutsch;
    private int korrekt, falsch;
    private GregorianCalendar gc;

    public Vokabel(String pe, String pd)
    {
        korrekt = falsch = 0;
        gc = new GregorianCalendar(2014,5,12,11,30);
        englisch = pe;
        deutsch = pd;
    }

    public String getDeutsch() {
        return deutsch;
    }

    public String getEnglisch() {
        return englisch;
    }

    public int getKorrekt() {
        return korrekt;
    }

    public int getFalsch() {
        return falsch;
    }

    public void inkrKorrekt() {
        korrekt++;
    }

    public void inkrFalsch() {
        falsch++;
    }

    public String getDatum() {
        int tag = gc.get(Calendar.DATE);
        int monat = gc.get(Calendar.MONTH);
        int jahr = gc.get(Calendar.YEAR);
        int stunde = gc.get(Calendar.HOUR_OF_DAY);
        int minute = gc.get(Calendar.MINUTE);
        return tag + "." + monat + "." + jahr + 
        " um " + stunde + ":" + minute;
    }
}
