
/**
 * Die Klasse Schleifen enthält
 * verschiedene Beispiele für Schleifen, auch geschachtelt
 * 
 * @docschroeder
 * @13.09.2012
 */
public class Schleifen
{

    public Schleifen()
    {
        /* Syntax von Zählschleifen: 
         * for (int i=startwert;Bedingung - wenn true, dann Ausführung des Anweisungsblockes;zähleranpassung immer danach) 
         *  {...Anweisungsblock...}
         *  
         *  Syntax von while-Schleifen ("Vorprüfenden Schleifen"):
         *  while (Bedingung) {... Anweisungsblock}
         *  wird ausgeführt, solange Bedingung true ist.
         *  */

        vorwaerts1();
        vorwaerts2();
        rueckwaerts();
        geschachtelt();
        whileSchleife();
    }

    public void vorwaerts1()
    {
        for (int i=0;i<=10;i++) {
            System.out.println("Vorwärtszählen in 1er Schritten:  i=" + i);
        }
        System.out.println("_____________________ " + '\n' + '\n'); //kurzer Strich und dann 2 Zeilenumbrüche
    }

    public void vorwaerts2()
    {
        for (int i=0;i<=25;i+=5) {
            System.out.println("Quadratzahlen in 5er Schritten:  i*i=" + i*i);
        }
        System.out.println("_____________________ " + '\n' + '\n');
    }

    public void rueckwaerts()
    {
        for (int i=100;i>0;i-=10) {
            System.out.println("Rückwärtszählen in 10er Schritten:  i=" + i);
        }
        System.out.println("_____________________ " + '\n' + '\n');
    }

    public void geschachtelt()
    {
        for (int i=0;i<10;i++) {
            for (int j=0;j<10;j++) {
                System.out.print(i + "*" + j + "=" + i*j + "   "); // Ausgabe des kleinen 1x1
            }
            System.out.print('\n'); // Zeilenumbruch immer, wenn innere Schleife einmal komplett durch ist
        }

        System.out.println("_____________________ " + '\n' + '\n');
    }

    public void whileSchleife() {
        long quadrat = 2;       //lokale Variable, nur in Methode existent!
                                //long bedeutet, sehr große ganze Zahlen möglich

        while (quadrat < 100000) {
            quadrat*=quadrat;
            System.out.println(quadrat + "");
        } 

        System.out.println("_____________________ " + '\n' + '\n');
    }
    
}
