 import java.awt.*;
import javax.swing.*;
import java.awt.Graphics;

/* Kurzanleitung zur Erstellung einfacher graphischer Ausgaben
 * auf einer Canvas (Leinwand). Handhabung hnlich wie JFrame,
 * da davon abgeleitet. Wichtig: methode paint() wird nie 
 * direkt aufgerufen, sondern nur ueber repaint().
 * Zu den einzelnen Methoden vergleiche API "Graphics"...
 */

public class Zeichnen extends JFrame
{

    private Wuerfel startwuerfel,wuerfel;

    public Zeichnen()
    {
        startwuerfel = new Wuerfel();
        wuerfel = new Wuerfel();
 
        new Canvas();
        setSize(1000,1000);
        setLocation(400,100);
        setDefaultCloseOperation(3);
        setResizable(false);
        setBackground(Color.WHITE);
        setVisible(true);
        repaint();
        
        
        
        
        
        
        
        while (true) {
            for (int i=0;i<=360;i++) {
                try {
                    Thread.sleep(10);
                    wuerfel = wuerfel.drehen(startwuerfel,i*1.0);
                    repaint();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void paint(Graphics g)
    {
        g.clearRect(0,0,getWidth(),getHeight());
        g.setColor(Color.BLACK);
        for (int i=0;i<3;i++) {
            g.drawLine(wuerfel.getPx(i),wuerfel.getPy(i),wuerfel.getPx(i+1),wuerfel.getPy(i+1));
        }
        g.drawLine(wuerfel.getPx(3),wuerfel.getPy(3),wuerfel.getPx(0),wuerfel.getPy(0));
        g.setColor(Color.RED);

        for (int i=4;i<7;i++) {
            g.drawLine(wuerfel.getPx(i),wuerfel.getPy(i),wuerfel.getPx(i+1),wuerfel.getPy(i+1));
        }
        g.drawLine(wuerfel.getPx(7),wuerfel.getPy(7),wuerfel.getPx(4),wuerfel.getPy(4));
        g.setColor(Color.MAGENTA);

        for (int i=0;i<4;i++) {
            g.drawLine(wuerfel.getPx(i),wuerfel.getPy(i),wuerfel.getPx(i+4),wuerfel.getPy(i+4));
        }

    }
}
