
public class Wuerfel
{
    private double [] px;    //Eckpunkte, x-Koordinaten
    private double [] py;    // y-Koordinaten
    private double a;         //Kantenlaenge

    public Wuerfel()
    {
        px = new double [8];
        py = new double [8];
        a = 100.0;

        px[0] = px[1] = 50.0;
        px[2] = px[3] = px[0]+a;
        py[0] = py[3] = 50.0;
        py[1] = py[2] = py[0]+a;

        px[4] = px[5] = px[0]+a*0.7*0.866;  //cos(30)
        px[6] = px[7] = px[0]+a+a*0.7*0.866;
        py[4] = py[7] = py[0]-a*0.7*0.5;    //sin(30)
        py[5] = py[6] = py[0]+a-a*0.7*0.5;              //0.6 ist Stauchungsfaktor durch Perspektive

    }

    /* Uebergeben wird der Startwuerfel und der Winkel,
     * daraus wird der gedrehte Wuerfel berechnet.
     * xm und ym sind die Koordinaten der Drehachse (Durchstichpunkte)
     */

    public Wuerfel drehen(Wuerfel w, double winkel) {
        
        Wuerfel wdreh = new Wuerfel();
        a = (w.py[1] - w.py[0]);
        double radius = a/1.414;
        double xm1 = w.px[0] + a/2 + winkel;
        double ym1 = w.py[0] + a/2 + winkel;
        double xm2 = w.px[4] + a/2 + winkel;
        double ym2 = w.py[4] + a/2 + winkel;

        for (int i=0;i<4;i++) {         //Vorderes Quadrat
            wdreh.px[i] = xm1 + radius*Math.cos(2*Math.PI*(winkel+135+i*90)/360);
            wdreh.py[i] = ym1 + radius*Math.sin(2*Math.PI*(winkel+135+i*90)/360);     
            wdreh.px[i+4] = xm2 +radius*Math.cos(2*Math.PI*(winkel+135+i*90)/360);
            wdreh.py[i+4] = ym2 +radius*Math.sin(2*Math.PI*(winkel+135+i*90)/360);
        }
        return wdreh;
    } 

    public int getPx(int n) {
        return (int) px[n];
    }

    public int getPy(int n) {
        return (int) py[n];
    }

}
