import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * Beinhaltet StringsandChars,
 * Caesar und
 * RSA-Verschluesselung
 * 
 * @author docschroeder
 * @version 06.06.2013 UB-Vorbereitung / Schuelervariante
 */
public class Chiffrieren_S extends JFrame implements ActionListener, ItemListener
{
    private JTextField tSuche;
    private JTextArea tEin,tAus; //Kompromiss: JTextArea nicht scrollable, aber alle Schriften - textArea umgekehrt
    private JButton [] jb;
    private JComboBox cbSchriften;
    private String [] schriften = {"Arial", "Serif","Sans Serif", "Batang", "Verdana", "Monotype Corsiva"};
    private String [] buttonText = {"ToAscii", "ToString", "Ersetzen", "Suchen", "Umlaute", "doppelt", "GROSSklein","ANS","Sonderzeichen", "Caesar", "nn", "nn", "nn", "nn"};

    boolean clicks = true;

    private Font f = new Font("Arial",0,22);
    private Font fHigh = new Font("Monospaced",1,30);

    private Color c = new Color(100,50,30);
    private Color cHigh = new Color(250,30,0);    

    public Chiffrieren_S()
    {
        super ("Umgang mit Strings und Characters, Chiffrieren");
        setSize(700,700);
        setLocation(300,50);
        setResizable(false);
        setLayout(null);
        setDefaultCloseOperation(3);

        getContentPane().setBackground(Color.YELLOW);

        tSuche = new JTextField("");
        tSuche.setFont(fHigh);
        tSuche.setForeground(cHigh);
        tSuche.setToolTipText("Such-String oder XY zum Ersetzen von X durch Y oder Caesar-Schluessel!"); 

        tEin = new JTextArea("");
        tEin.setFont(f);
        tEin.setForeground(c);

        tAus = new JTextArea("");
        tAus.setFont(f);
        tAus.setForeground(c);
        tAus.setEditable(false);

        cbSchriften = new JComboBox(schriften); //neue JComboBox enthaelt alle elemente des String-Arrays schriften

        tSuche.setBounds(20,320,300,30);
        tEin.setBounds(20,20,500,250);
        tAus.setBounds(20,400,500,250);
        cbSchriften.setBounds(550,620,120,30);
        cbSchriften.addItemListener(this);  //ItemListener, oben implememtiert, erwartet itemStateChanged(ItemEvent ie)

        add(tSuche);
        add(tEin);
        add(tAus);
        add(cbSchriften);

        jb = new JButton [buttonText.length];
        for (int i=0;i<buttonText.length;i++) {
            jb[i] = new JButton(buttonText[i]);
            jb[i].setBounds(getWidth()-140,20+i*40,120,38);
            jb[i].addActionListener(this);
            add(jb[i]);

        }

        setVisible(true);
    }

    public String stringToAscii(String ps) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public String asciiToString(String ps) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public String umlauteEntfernen(String ps) {
        String dummy = "";
        String [] umlaute = {"Ä", "Ö", "Ü", "ä", "ö", "ü","ß"};
        String [] ersatz = {"Ae", "Oe", "Ue", "ae", "oe", "ue", "ss"};
        for (int i=0; i<umlaute.length;i++) {
            ps = ps.replace(umlaute[i],ersatz[i]);
        }
        return ps;
    }

    public String suchen(String ps, String pt) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public String doppelteEntfernen(String ps) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public String sonderzeichenEntfernen(String ps) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public String caesar(int n, String ps) {
        return "Hallo Welt"; // Hier fehlt sinnvoller Quelltext!!!
    }

    public void actionPerformed(ActionEvent e)  //nur fuer Buttons verwendet
    {
        String textEingabe = tEin.getText();
        String textAusgabe = "";
        tAus.setBackground(Color.WHITE);

        Object o = e.getSource();

        if (o==jb[0])      {textAusgabe = stringToAscii(textEingabe);}   // toAscii
        else if (o==jb[1]) {textAusgabe = asciiToString(textEingabe + " ");}   //// toChar , gewaehrleistet, dass immer Leerzeichen am ende
        else if (o==jb[2]) {textAusgabe = textEingabe.replace(tSuche.getText().charAt(0),tSuche.getText().charAt(1));} // ersetzen
        else if (o==jb[3]) {textAusgabe = suchen(textEingabe,tSuche.getText());}   // suchen
        else if (o==jb[4]) {textAusgabe = umlauteEntfernen(textEingabe);}     // umlaute entfernen
        else if (o==jb[5]) {textAusgabe = doppelteEntfernen(textEingabe);}     // doppelte entfernen
        else if (o==jb[6]) {// Umschaltung Gross/klein
            textAusgabe = textEingabe.toLowerCase();
            if (clicks) {textAusgabe = textEingabe.toUpperCase();}
            clicks = !clicks;
        }
        else if (o==jb[7]) {tEin.setText(tAus.getText());}  //ANS
        else if (o==jb[8]) {textAusgabe = sonderzeichenEntfernen(textEingabe);}   //Sonderzeichen entfernen
        else if (o==jb[9]) {textAusgabe = caesar(new Integer (tSuche.getText()).intValue(),sonderzeichenEntfernen(umlauteEntfernen(textEingabe.toLowerCase())));}    //CAESAR

        tAus.setText(textAusgabe);
    }

    public void itemStateChanged(ItemEvent ie) //im ItemEvent steht das angeklickte Item drin
    { 
        tAus.setFont(new Font(ie.getItem().toString(),0,22));   //item muss noch in String konvertiert werden
    }

    public static void main(String[] args) {
        new Chiffrieren_S();
    }
}
