
/* dochschroeder 15.11.2010
Diese Klasse beschreibt ein einfaches Girokonto und erlaeutert den 
Umgang mit Klassen und deren Instanzen und Interaktionen zwischen diesen.

 */
public class Konto
{
    // Deklaration der Instanzvariablen, ausserhalb der Methoden!
    // So stehen sie allen Methoden zur Verfuegung und sind nicht
    // nur lokal verfuegbar.
    private int kontoStand;     //Alle Variablen private, dadurch nur aus der class heraus
    private int kontoNummer;    //aufrufbar! 
    private String kontoInhaber;

    public Konto()  
    // Konstruktor, erzeugt die Instanzen. 
    // Quasi Methode,aber ohne Rueckgabetyp. */
    {
        kontoStand=50;      // initialisieren der Instanzvariablen
        kontoNummer=4711;
        kontoInhaber="Erich Mustermann";
    }

    public Konto (int nr, String name)  
    //ueberladen von Konstruktoren und Methoden
    //gleicher Name, aber andere Parameter!
    {
        kontoStand=50;
        kontoNummer=nr;
        kontoInhaber=name;
    }

    /* Achtung: In den folgenden beiden Methoden wird das aufrufende Objekt
     * vom Typ Konto implizit mit uebergeben. Deshalb weiss die Methode auszahlen(),
     * welches Konto (es koennen ja beliebig viele Objekte dieses Typs existieren) verwendet
     * werden soll. Um Methoden fuer ein beliebiges Konto aufzurufen, muss das Konto mit
     * uebergeben werden. (Siehe Projekt Konto2). */

    public void einzahlen (int betrag) 
    {
        if (betrag>=0) {
            kontoStand+=betrag;     //erlaubt den Zugriff auf private kontoStand!
        }
    }

    public void auszahlen (int betrag)
    {
        if (kontoStand>=betrag && betrag >=0) {  // nur wenn betrag<Stand und positiv
            kontoStand-=betrag;
        }
    }

    public int getKontoStand() //getter-Methode, gibt private Variable auch nach draussen
    {
        return kontoStand;
    }

    public int getKontoNummer()
    {
        return kontoNummer;
    }

    public String getKontoInhaber()
    {
        return kontoInhaber;
    }

}
