/* EchoClient.java */

import java.net.*;
import java.io.*;

public class EchoClient
{
    public static void main(String[] args)
    {

        try {
            Socket sock = new Socket(args[0], 1050);   // echo-port 7
            InputStream in = sock.getInputStream(); 
            OutputStream out = sock.getOutputStream();
            sock.setSoTimeout(300); 
            /*  Der Aufruf von setSoTimeout gibt die maximale Wartezeit bei einem lesenden Zugriff 
             * auf den Socket an (300 ms.). Wenn bei einem read auf den InputStream nach Ablauf 
             * dieser Zeit noch keine Daten empfangen wurden, 
             * terminiert die Methode mit einer InterruptedIOException;
             * 
             * Ausgabethread erzeugen*/
            OutputThread th = new OutputThread(in);
            
            th.start();     //VM startet run()-Methode des OutputThread-Objektes (erbt von Thread!!!)
            
            //Schleife für Benutzereingaben
            BufferedReader conin = new BufferedReader(
                    new InputStreamReader(System.in));
            String line = "";
            while (true) { 
                //Eingabezeile lesen
                line = conin.readLine();
                if (line.equalsIgnoreCase("QUIT")) {
                    break;
                }
                //Eingabezeile an ECHO-Server schicken
                out.write(line.getBytes());
                out.write('\r');
                out.write('\n');
            }
            
            //Programm beenden
            System.out.println("terminating output thread...");
            th.requestStop();
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }
            in.close(); 
            out.close();
            sock.close();
        } catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }
}

class OutputThread
extends Thread
{
    InputStream in;
    boolean     stoprequested;

    public OutputThread(InputStream in)
    {
        super();
        this.in = in;
        stoprequested = false;
    }

    public synchronized void requestStop()
    {
        stoprequested = true;
    }

    public void run()
    {
        int len;
        byte[] b = new byte[100];
        try {
            while (!stoprequested) { 
                try {
                    if ((len = in.read(b)) == -1) { 
                        break;
                    }
                    System.out.write(b, 0, len);
                } catch (InterruptedIOException e) { 
                    //nochmal versuchen
                }
            }
        } catch (IOException e) {
            System.err.println("OutputThread: " + e.toString());
        }
    }
    /*Die Klasse OutputThread implementiert den Thread zum Lesen und Ausgeben der Daten.  
     *Da die Methode stop der Klasse Thread als deprecated markiert wurde, 
     *müssen wir mit Hilfe der Variable stoprequested etwas mehr Aufwand treiben, um den 
     *Thread beenden zu können. stoprequested steht normalerweise auf false und wird 
     *beim Beenden des Programms durch Aufruf von requestStop auf true gesetzt. In der 
     *Hauptschleife des Threads wird diese Variable periodisch abgefragt, um die Schleife 
     *bei Bedarf abbrechen zu können. Problematisch bei dieser Technik ist 
     *lediglich, dass der Aufruf von read normalerweise so lange blockiert, bis weitere 
     *Zeichen verfügbar sind. Steht das Programm also in Zeile 086, so hat ein Aufruf 
     *requestStop zunächst keine Wirkung. Da das Hauptprogramm die Streams 
     *und den Socket schließt, würde es zu einer SocketException kommen. Unser Programm 
     *verhindert das durch den Aufruf von setSoTimeout. Dadurch wird ein Aufruf 
     *von read nach spätestens 300 ms. mit einer InterruptedIOException beendet. Diese Ausnahme 
     *wird abgefangen, um anschließend vor dem nächsten Schleifendurchlauf die 
     *Variable stoprequested erneut abzufragen. 
     */

}
