 import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ZahlungsverkehrGUI extends JFrame implements ActionListener
{
    private JButton bEinzahlen, bAuszahlen, bUeberweisen;
    private JLabel lBetrag, lStartkto, lZielkto;
    private JTextField tBetrag, tStartkto, tZielkto;

    private Bank bank;
    
/* Der Konstruktor der GUI bekommt die komplette Bank als Parameter uebergeben.
 * Achtung: Keine Kopie der Bank, sondern eine Referenz ("Zeiger") auf das Objekt. Wenn 
 * also die Bank veraendert wird, merkt man das sofort in BEIDEN KLASSEN!
 */
    public ZahlungsverkehrGUI(Bank b)
    {
        bank = b;

        bEinzahlen = new JButton("Einzahlen");
        bAuszahlen = new JButton("Auszahlen");
        bUeberweisen = new JButton("Ueberweisen");
        lBetrag = new JLabel("Betrag eingeben");
        lStartkto = new JLabel("Kontonummer eingeben");
        lZielkto = new JLabel("Bei berweisungen: Zielkontonummer");
        tBetrag = new JTextField("");
        tStartkto = new JTextField("");
        tZielkto = new JTextField("");        

        new JFrame();
        setDefaultCloseOperation(1);        //(1) anstelle (3), sonst schliessen sich alle Fenster
        setTitle("GAT - Die Beraterbank - Zahlungsverkehr");
        setSize(600,600);
        setResizable(false);
        setLocation(20,20);
        setLayout(null);

        bEinzahlen.setBounds(30, 500,180,40);
        bAuszahlen.setBounds(210,500,180,40);
        bUeberweisen.setBounds(390,500,180,40);
        lBetrag.setBounds(30,30,280,40);
        lStartkto.setBounds(30,150,280,40);
        lZielkto.setBounds(30,270,280,40);
        tBetrag.setBounds(30,80,280,40);
        tStartkto.setBounds(30,200,280,40);
        tZielkto.setBounds(30,320,280,40);

        add(bEinzahlen);
        add(bAuszahlen);
        add(bUeberweisen);
        add(lBetrag);
        add(lStartkto);
        add(lZielkto);
        add(tBetrag);
        add(tStartkto);
        add(tZielkto);

        bEinzahlen.addActionListener(this);
        bAuszahlen.addActionListener(this);
        bUeberweisen.addActionListener(this);

        setVisible(true);

    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource()==bEinzahlen) {
            int ktonr = new Integer (tStartkto.getText()).intValue();
            double betrag = new Double (tBetrag.getText()).doubleValue();
            bank.einzahlen(ktonr,betrag);
        } else if (e.getSource()==bAuszahlen) {
            int ktonr = new Integer (tStartkto.getText()).intValue();
            double betrag = new Double (tBetrag.getText()).doubleValue();
            bank.auszahlen(ktonr,betrag);
        }
        else {
            int startktonr = new Integer (tStartkto.getText()).intValue();
            int zielktonr = new Integer (tZielkto.getText()).intValue();
            double betrag = new Double (tBetrag.getText()).doubleValue();
            bank.ueberweisen(startktonr,zielktonr,betrag);

        }

    }

}
