import java.util.ArrayList;
/**
 * Die Klasse Kunde beschreibt die Attribute und Methoden
 * der Bankkunden.
 * @author docschroeder
 * @version 11032011 
 */
public class Kunde
{
    private String nachname;
    private String vorname;
    private int gebjahr;
    private int kdnummer;
    private ArrayList<Konto> konto;

    /**
     * Konstruktor fuer Objekte der Klasse Kunde, Uebergabe der Kundennummer!.
     * Der Kunde haelt eine ArrayList mit seinen Konten.
     * @param nn=Nachname, vn=Vorname,j=Geburtsjahr, nr=Kundennummer
     */
    public Kunde(String nn, String vn, int j, int nr)
    {
        // initialise instance variables
        nachname = nn;
        vorname = vn;
        gebjahr = j;
        kdnummer = nr;
        konto = new ArrayList<Konto>();
    }

    public String getName() {
        return nachname;
    }

    public void setName(String s) {
        nachname = s;
    }

    public String getVorname() {
        return vorname;
    }

    public int getJahr() {
        return gebjahr;
    }

    public int getKundennummer() {
        return kdnummer;
    }
    
    /** Gibt die Zahl der Konten eines Kunde-Objektes zurueck.
     *  Die Methode wird an einem Kunde-Objekt aufgerufen!
     */
    public int getKontenzahl() {
        return this.konto.size();
    } 

    /** Gibt ein komplettes Konto zurueck.
     * der Index k bezeichnet die laufende Nummer des Kontos,
     * also 0 wenn ein Kunde nur 1 Konto hat.
     * Die Methode wird an einem Kunde-Objekt aufgerufen!
     * @param k = laufende Nummer des Kontos
     * @return komplettes Konto
     */
    public Konto getKonto(int k) {
        return this.konto.get(k);    
    }
    
    /** Erzeugt ein neues Konto, 
     * die Kontonummer wird eindeutig aus Kundennummer 
     * und fortlaufender Nummerierung bei mehreren Konten erzeugt.
     */
    public void kontoAnlegen() {
        int kontonr = this.kdnummer*100+this.konto.size();
        konto.add(new Konto(kontonr));
    }   

}
