
/**
 * Die Kontonummer wird als Parameter uebergeben.
 * 
 * @author docschroeder 
 * @version 11032011
 */
public class Konto
{
    private int kontoNummer;
    private int kontoPin;
    private double kontoStand;
    private double dispo;

    public Konto(int ktonr)
    {
        kontoNummer = ktonr;
        kontoStand = 0.00;
        dispo = 0.00;
        kontoPin = 1234;
    }

    public int getKontoNummer() {
        return this.kontoNummer;
    }

    public double getKontoStand() {
        return this.kontoStand;
    }

    public double getDispo() {
        return this.dispo;
    }

    /**
     *Vergleicht die uebergebene Pin mit der existierenden Pin. 
     */
    public boolean pinPruefen(int pin) {
        return (pin==this.kontoPin);
    }

    /**
     * verwendet pinPruefen() fuer die alte Pin.
     * Bei false passiert nichts.
     */
    public void setPin(int pinalt, int pinneu) {
        if (pinPruefen(pinalt)) {
            this.kontoPin = pinneu;
        }
    }

    public void setDispo(int disponeu) {
        dispo = disponeu;
    }

    public void einzahlen(double betrag){
        this.kontoStand += betrag;
    }


    /**
     * auszahlen() prueft dispo!
     */
    public void auszahlen(double betrag){
        if (this.kontoStand-betrag>=-dispo) {
            this.kontoStand -= betrag;
        } else {
            System.out.println("Konto ueberzogen :-(((   ");
        }
    }

    /**
     * ueberweisen() verwendet ein Objekt vom Typ Konto als Zielkonto,
     * dieses wird komplett als Parameter uebergeben!
     * Auch ueberweisen() prueft dispo.
     */
    public void ueberweisen(double betrag, Konto zielkonto) {
        if (this.kontoStand-betrag>=-dispo) {
            this.auszahlen(betrag);
            zielkonto.einzahlen(betrag);
        } else {
            System.out.println("Konto ueberzogen :-(((   ");
        }
    }
}
