import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Erzeugt die Bank und die ZahlungsverkehrGUI ("HAT" - Beziehung)
 */
public class HauptGUI extends JFrame implements ActionListener
{
    private Bank bank;
    private ZahlungsverkehrGUI zvGUI;

    private JButton bNeuerKunde, bNeuesKonto, bKundenuebersicht, bKontenuebersicht, bZahlverkehr;
    private JLabel lName,lVorname,lGebjahr, lKdnr, lKtonr;
    private JTextField tName,tVorname,tGebjahr, tKdnr,tKtonr;
    public JTextArea tAusgabe;

    /**
     * erzeugt eine Bank namens bank und das JFrame mit dem Startfenster
     */
    public HauptGUI()
    {
        bank = new Bank();

        bNeuerKunde    = new JButton("Neukunde anlegen");
        bNeuesKonto = new JButton("Neues Konto anlegen");
        bKundenuebersicht = new JButton("Kundenuebersicht");
        bKontenuebersicht = new JButton("Kontenuebersicht");
        bZahlverkehr = new JButton("Zahlungsverkehr");

        lName = new JLabel("Name:");
        lVorname = new JLabel("Vorname:");
        lGebjahr = new JLabel("Geburtsjahr:");
        lKdnr = new JLabel("Kundennummer");
        lKtonr = new JLabel("Kontonummer");

        tName = new JTextField("");
        tVorname = new JTextField("");
        tGebjahr = new JTextField("");
        tKdnr = new JTextField("");
        tKtonr = new JTextField("");

        tAusgabe = new JTextArea("");

        new JFrame();       //Konstruktor wird aufgerufen, keine Parameter
        setDefaultCloseOperation(1);
        setTitle("GAT - Die Beraterbank - Kundenverwaltung");
        setSize(1200,800);   //Groesse (Breite, Hoehe)
        setResizable(false);//kann nicht veraendert werden
        setLocation(20,20);//Bildschirmposition
        setLayout(null);    //leeres Objekt, sonst geht Frame nicht richtig!

        bNeuerKunde.setBounds(30,500,180,40);
        bNeuesKonto.setBounds(30,540,180,40);
        bKundenuebersicht.setBounds(210,500,180,40);
        bKontenuebersicht.setBounds(210,540,180,40);
        bZahlverkehr.setBounds(30,580,360,40);
        tName.setBounds(30,45,120,40);
        tVorname.setBounds(200,45,120,40);
        tGebjahr.setBounds(370,45,120,40);
        tKdnr.setBounds(30,125,120,40);
        tKtonr.setBounds(200,125,120,40);
        tAusgabe.setBounds(550,30,600,600);
        lName.setBounds(30,15,120,30);
        lVorname.setBounds(200,15,120,30);
        lGebjahr.setBounds(370,15,120,30);
        lKdnr.setBounds(30,90,120,40);
        lKtonr.setBounds(200,90,120,40);

        add(bNeuerKunde);
        add(bNeuesKonto);
        add(bKundenuebersicht);
        add(bKontenuebersicht);
        add(bZahlverkehr);
        add(tName);
        add(tVorname);
        add(tGebjahr);
        add(tAusgabe);
        add(tKdnr);
        add(tKtonr);
        add(lName);
        add(lVorname);
        add(lGebjahr);
        add(lKdnr);
        add(lKtonr);

        bNeuerKunde.addActionListener(this);
        bNeuesKonto.addActionListener(this);
        bKundenuebersicht.addActionListener(this);
        bKontenuebersicht.addActionListener(this);
        bZahlverkehr.addActionListener(this);

        setVisible(true);                   //immer als letzten Befehl!!!

    }

    public void actionPerformed(ActionEvent e) { //beim Event wird diese Methode aufgerufen
        if (e.getSource() == bNeuerKunde) {  
            if (tName.getText().equals("") || tVorname.getText().equals("") || tGebjahr.getText().equals("")) {
                tAusgabe.setText("BITTE VOLLSTNDIGE WERTE ANGEBEN!!!");
            } else {

                String n = tName.getText();
                String v = tVorname.getText();
                int j = new Integer(tGebjahr.getText()).intValue();
                tName.setText("");
                tVorname.setText("");
                tGebjahr.setText("");
                tAusgabe.setText("");
                bank.kdAnlegen(n,v,j);
            }

        } else if (e.getSource() == bKundenuebersicht) {  

            String s = "Ueberblick ueber die momentanen Bankkunden der GAT-Beraterbank: " + '\n' + '\n';

            s += "Name, Vorname, Geburtsjahr, Kundennummer, Zahl der Konten" + '\n' +'\n';
            s += bank.kdUebersicht();

            tAusgabe.setColumns(5);     //funktioniert offenbar nicht?!?!

            tAusgabe.setText(s);
        }

        else if (e.getSource() == bKontenuebersicht) {

            if (tKdnr.getText().equals("") && tKtonr.getText().equals("")) {
                tAusgabe.setText("BITTE KUNDEN- oder KONTONUMMER ANGEBEN!!!");
            } else {
                if (!tKdnr.getText().equals("")) {
                    String s = "Konten zur angegebenen Kundennummer: " + '\n';
                    s += bank.zeigeKontonummern(new Integer (tKdnr.getText()).intValue());
                    tAusgabe.setText(s);
                } else {
                    String s = "Kontodaten des angegebenen Kontos: " + '\n';
                    s += bank.zeigeKontostand(new Integer (tKtonr.getText()).intValue());
                    tAusgabe.setText(s);
                }

            }
        }
        else if (e.getSource() == bNeuesKonto) {

            if (tKdnr.getText().equals("")) {
                tAusgabe.setText("BITTE KUNDENNUMMER ANGEBEN!!!");
            } else {      
                bank.kontoAnlegen(new Integer (tKdnr.getText()).intValue());
                tAusgabe.setText("Neues Konto");
            }

        }
        else if (e.getSource() == bZahlverkehr) {
            /* Beim Erzeugen der ZahlungsverkehrGUI wird dieser die komplette Bank
             * als Referenz mit uebergeben. Dadurch KENNT die GUI die Bank inklusive
             * aller Methoden! An die Attribute kommt man trotzdem nur ueber die
             * get-Methoden, da sie private sind.
             */
            zvGUI = new ZahlungsverkehrGUI(bank);            

        }
    }

    public static void main(String [] args) {
        new HauptGUI();
    }

}
