import java.util.ArrayList;

/**
 * Die Klasse Bank haelt Elemente vom Typ Kunde in einer
 * ArrayList. Diese Klasse ist hierfuer aus den java.utilities 
 * zu importieren.
 * 
 * @author docschroeder 
 * @version 11032011
 */
public class Bank
{
    /**Deklaration einer ArrayList namens kunde mit Elementen 
     * vom Typ Kunde (eigene Klasse!!!)
     */
    private ArrayList<Kunde> kunde;

    /**
     * Der Konstruktor der Bank erzeugt nur
     * die als Instanzvariable deklarierte ArrayList
     */
    public Bank()
    {
        kunde = new ArrayList<Kunde>();
    }

    /**
     * Anlegen eines neuen Kunden und hinzufuegen zur Liste.
     * Die Kundennummer wird auf 1001 plus die Zahl der Kunden
     * fortlaufend gesetzt. Das Geburtsjahr wird bei 2stelliger
     * Eingabe auf 19xx bzw. 20xx gesetzt.
     * @param n Nachname, v Vorname, j Geburtsjahr
     */
    public void kdAnlegen(String n, String v, int j)
    {
        int nr = kunde.size()*10 + 10001;
        if (j<100 && j>11) {
            j += 1900;
        }
        if (j<12) {
            j +=2000;
        }
        kunde.add(new Kunde(n,v,j,nr));
    }

    /**
     * Loescht den letzten hinzugefuegten Kunden.
     */
    public void kdLoeschen() {
        kunde.remove(kunde.size()-1);
    }

    /**
     * Loescht den angegeben Kunden.
     * Beispiel fuer ueberladene Methoden!
     * Die auf den geloeschten Kunden folgenden
     * Eintraege werden um eine Position nach links
     * verschoben (Indizes verschieben sich!), die Liste um 1 kuerzer.
     * @param n Index des zu loeschenden Elementes
     */
    public void kdLoeschen(int n) {
        kunde.remove(n);
    }

    /**
     * Ausgabe aller momentan existierenden Kunden
     */
    public String kdUebersicht() {
        String s = "";
        for (int i=0;i<kunde.size();i++) {
            s += kunde.get(i).getName() + " , " + kunde.get(i).getVorname()
            + " , " + kunde.get(i).getJahr() + " , " + kunde.get(i).getKundennummer()
            + " , " + kunde.get(i).getKontenzahl() + '\n';
        }
        return s;
    }

    /**
     * Ausgabe der Kundennummer(n)zu einem uebergebenen (Nach-)namen.
     * Bei mehreren gleichen Namen werden alle Treffer aufgelistet!
     * Aus der ArrayList "kunde" wird mit der Methode get(i) das i-te
     * Element (also ein Objekt vom Typ Kunde!) geholt. Daran wird mit
     * getName() eine public Methode der Klasse Kunde aufgerufen,
     * um das private Attribut "name" des Kunden zurueckzugeben.
     * @param n Nachname
     */
    public String sucheKundennummer(String n) {
        String s = "";
        for (int i=0;i<kunde.size();i++) {

            if (kunde.get(i).getName().equals(n)) {
                s += "Kundennummer zum Nachnamen " + n +"  : "+  kunde.get(i).getKundennummer();    
            }
        }
        if (s.equals("")) {
            return "Dieser Name existiert nicht!";
        } else {
            return s;
        }

    }

    /** Erzeugen eines neuen Kontos zur angebebenen Kundennummer.
     * Falls Kundennummer nicht existiert, wird NICHTS gemacht!
     */
    public void kontoAnlegen(int kdnr) {
        for (int i=0;i<kunde.size();i++) {
            if (kunde.get(i).getKundennummer()==kdnr) {
                kunde.get(i).kontoAnlegen();
            }
        }

    }

    /** Ausgabe aller Kontennummern zu einer Kundennummer.
     * 
     */
    public String zeigeKontonummern(int kdnr) {
        String s = "";
        for (int i=0;i<kunde.size();i++) {
            if (kunde.get(i).getKundennummer()==kdnr) {
                s="Kunde gefunden!,   " + kunde.get(i).getKontenzahl() + " Konten" + '\n';
                for (int j=0;j<kunde.get(i).getKontenzahl();j++) {
                    s += kunde.get(i).getKonto(j).getKontoNummer();
                    s += '\n';
                }
            }
        }
        return s;
    }

    /** Konsoleausgabe saemtlicher Kunden- und  Kontendaten zu einer Kontonummer.
     *  
     */
    public String zeigeKontostand(int ktonr) {
        if (kontoExistiert(ktonr)) {
            return "Kontostand des Kontos " + ktonr + " betrgt " + getKonto(ktonr).getKontoStand();
        } else {
            return "Konto existiert nicht!!!";
        }
    }

    /** Prueft, ob Konto existiert. ImFolgenden sollten alle Konsolenausgaben elimiert und durch
     * Textausgabe in die JTextArea ersetzt werden.
     * Beispiel: Siehe zeigeKontostand()
     */
    public void einzahlen(int ktonr, double betrag) {
        if (kontoExistiert(ktonr)) {
            getKonto(ktonr).einzahlen(betrag);
        } else {
            System.out.println("Konto existiert nicht !" );
        }

    }

    /** Prueft, ob Konto gedeckt ist.
     * 
     */
    public void auszahlen(int ktonr, double betrag) {
        if (deckungPruefen(ktonr, betrag)) {
            getKonto(ktonr).auszahlen(betrag);
        } else {
            System.out.println("Konto nicht gedeckt oder nicht existent :-((( ");
        }
    }

    /** Prueft, ob zielKonto existiert und ob vonKonto gedeckt ist.
     * 
     */
    public void ueberweisen(int vonKtonr, int nachKtonr, double betrag) {
        if (deckungPruefen(vonKtonr, betrag) && kontoExistiert(nachKtonr)) {
            auszahlen(vonKtonr, betrag);
            einzahlen(nachKtonr, betrag);
        } else {
            System.out.println("Konto nicht gedeckt oder nicht existent :-((( ");
            System.out.println("Keinerlei Aktion ausgefuehrt!");

            //ALLE KONSOLENAUSGABEN SOLLTEN UEBER DIE TEXTAREA LAUFEN!!!
        }

    }

    /** Holt das Konto zur Kontonummer. Vorsicht, wenn Konto nicht existiert, kommt Null-Objekt zurueck
     * Das sollte ausgeschlossen werden!
     */
    public Konto getKonto(int ktonr) {
        if (!kontoExistiert(ktonr)) {
            System.out.println("Konto existiert nicht!!!");
            return null;
        } else {
            for (int i=0;i<kunde.size();i++) {
                for (int j=0;j<kunde.get(i).getKontenzahl();j++) {
                    if (kunde.get(i).getKonto(j).getKontoNummer()==ktonr) {
                        return kunde.get(i).getKonto(j);
                    } 
                }
            }
            return null;
        }
    }

    /** Prueft ob Konto existiert und gedeckt ist.
     * 
     */
    public boolean deckungPruefen(int ktonr, double betrag) {
        if (!kontoExistiert(ktonr)) {
            return false;
        } else {
            return(0 <= (getKonto(ktonr).getKontoStand() + getKonto(ktonr).getDispo()-betrag));
        } 
    }

    /** Prueft ob Konto existiert
     * 
     */
    public boolean kontoExistiert(int ktonr) {
        boolean treffer = false;
        for (int i=0;i<kunde.size();i++) {
            for (int j=0;j<kunde.get(i).getKontenzahl();j++) {
                if (kunde.get(i).getKonto(j).getKontoNummer()==ktonr) {
                    return true;
                } 
            }

        }
        return false;
    }
}
