/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Bank {
    private ArrayList<Kunde> kunde = new ArrayList();

    public void kdAnlegen(String n, String v, int j) {
        int nr = this.kunde.size() * 10 + 10001;
        if (j < 100 && j > 11) {
            j += 1900;
        }
        if (j < 12) {
            j += 2000;
        }
        this.kunde.add(new Kunde(n, v, j, nr));
    }

    public void kdLoeschen() {
        this.kunde.remove(this.kunde.size() - 1);
    }

    public void kdLoeschen(int n) {
        this.kunde.remove(n);
    }

    public String kdUebersicht() {
        String s = "";
        for (int i = 0; i < this.kunde.size(); ++i) {
            s = s + this.kunde.get(i).getName() + " , " + this.kunde.get(i).getVorname() + " , " + this.kunde.get(i).getJahr() + " , " + this.kunde.get(i).getKundennummer() + " , " + this.kunde.get(i).getKontenzahl() + '\n';
        }
        return s;
    }

    public String sucheKundennummer(String n) {
        String s = "";
        for (int i = 0; i < this.kunde.size(); ++i) {
            if (!this.kunde.get(i).getName().equals(n)) continue;
            s = s + "Kundennummer zum Nachnamen " + n + "  : " + this.kunde.get(i).getKundennummer();
        }
        if (s.equals("")) {
            return "Dieser Name existiert nicht!";
        }
        return s;
    }

    public void kontoAnlegen(int kdnr) {
        for (int i = 0; i < this.kunde.size(); ++i) {
            if (this.kunde.get(i).getKundennummer() != kdnr) continue;
            this.kunde.get(i).kontoAnlegen();
        }
    }

    public String zeigeKontonummern(int kdnr) {
        String s = "";
        for (int i = 0; i < this.kunde.size(); ++i) {
            if (this.kunde.get(i).getKundennummer() != kdnr) continue;
            s = "Kunde gefunden!,   " + this.kunde.get(i).getKontenzahl() + " Konten" + '\n';
            for (int j = 0; j < this.kunde.get(i).getKontenzahl(); ++j) {
                s = s + this.kunde.get(i).getKonto(j).getKontoNummer();
                s = s + '\n';
            }
        }
        return s;
    }

    public String zeigeKontostand(int ktonr) {
        if (this.kontoExistiert(ktonr)) {
            return "Kontostand des Kontos " + ktonr + " betr\u00e4gt " + this.getKonto(ktonr).getKontoStand();
        }
        return "Konto existiert nicht!!!";
    }

    public void einzahlen(int ktonr, double betrag) {
        if (this.kontoExistiert(ktonr)) {
            this.getKonto(ktonr).einzahlen(betrag);
        } else {
            System.out.println("Konto existiert nicht !");
        }
    }

    public void auszahlen(int ktonr, double betrag) {
        if (this.deckungPruefen(ktonr, betrag)) {
            this.getKonto(ktonr).auszahlen(betrag);
        } else {
            System.out.println("Konto nicht gedeckt oder nicht existent :-((( ");
        }
    }

    public void ueberweisen(int vonKtonr, int nachKtonr, double betrag) {
        if (this.deckungPruefen(vonKtonr, betrag) && this.kontoExistiert(nachKtonr)) {
            this.auszahlen(vonKtonr, betrag);
            this.einzahlen(nachKtonr, betrag);
        } else {
            System.out.println("Konto nicht gedeckt oder nicht existent :-((( ");
            System.out.println("Keinerlei Aktion ausgefuehrt!");
        }
    }

    public Konto getKonto(int ktonr) {
        if (!this.kontoExistiert(ktonr)) {
            System.out.println("Konto existiert nicht!!!");
            return null;
        }
        for (int i = 0; i < this.kunde.size(); ++i) {
            for (int j = 0; j < this.kunde.get(i).getKontenzahl(); ++j) {
                if (this.kunde.get(i).getKonto(j).getKontoNummer() != ktonr) continue;
                return this.kunde.get(i).getKonto(j);
            }
        }
        return null;
    }

    public boolean deckungPruefen(int ktonr, double betrag) {
        if (!this.kontoExistiert(ktonr)) {
            return false;
        }
        return 0.0 <= this.getKonto(ktonr).getKontoStand() + this.getKonto(ktonr).getDispo() - betrag;
    }

    public boolean kontoExistiert(int ktonr) {
        boolean treffer = false;
        for (int i = 0; i < this.kunde.size(); ++i) {
            for (int j = 0; j < this.kunde.get(i).getKontenzahl(); ++j) {
                if (this.kunde.get(i).getKonto(j).getKontoNummer() != ktonr) continue;
                return true;
            }
        }
        return false;
    }
}

